# SOLID

 O termo SOLID é um acrônimo dos cinco primeiros princípiocs ("five first principles") da programação orientada à objetos e design de código identificados por Robert C. Martin (ou Uncle Bob), destinados a fazer projetos de software mais compreensíveis, flexíveis e de fácil manutenção.

 S – Single Responsibility Principle (SRP): princípio da responsabilidade única;

 O – Open Closed Principle (OCP): princípio do aberto/fechado;

 L – Liskov Substituition Principle (LSP): princípio da substituição de Liskov;

 I – Inteface Segregation Principle (ISP): princípio da segregação de interfaces;

 D – Dependency Inversion Principle (DIP): princípio da inversão de dependência.


### Os princípios SOLID aplicado visa obter os benefícios da orientação a objetos:

. Seja fácil de se manter, adaptar e se ajustar às alterações de escopo;

. Seja testável e de fácil entendimento;

. Seja extensível para alterações com o menor esforço necessário;

. Que forneça o máximo de reaproveitamento;

. Que permaneça o máximo de tempo possível em utilização.

### Utilizando os princípios SOLID é possível evitar problemas:

Dificuldade na testabilidade / criação de testes de unidade;
Código macarrônico, sem estrutura ou padrão;
Dificuldades de isolar funcionalidades;
Duplicação de código, uma alteração precisa ser feita em N pontos;
Fragilidade, o código quebra facilmente em vários pontos após alguma mudança


A seguir vamos estudar cada um dos 5 príncipios que compõem o SOLID.

[Single Responsability Principle](#single-responsability-principle) :arrows_counterclockwise:

[Open-Closed Principle](#open-closed-principle)

[Liskov Substitution Principle](#liskov-substitution-principle)

[Interface Segregation Principle](#interface-segregation-principle)

[Dependency Inversion Principle](#dependency-inversion-principle) :heavy_check_mark:



### Referências:

Princípios, Padrões e Práticas Ágeis em C# (Português) por Robert Martin (Autor),‎ Micah Martin (Autor)

Criando Domínios Ricos : PARTE 2 - PRINCÍPIOS SOLID - http://player.balta.io/#/courses/1934-B

Curso SOLID com C#: Orientação a Objetos com C# - https://cursos.alura.com.br/course/orientacao-a-objetos-avancada-e-principios-solid-csharp

Princípios SOLID - http://www.macoratti.net/11/05/pa_solid.htm

Orientação a Objeto – SOLID - https://www.net.br/2013/04/orientacao-a-objeto-solid/

Clean Code – Uncle Bob

Wikipedia - https://pt.wikipedia.org/wiki/SOLID
